using System;

using Borland.Data.Provider;
using Borland.Data.Common;

using System.Data;

using System.IO;
using System.Text;

namespace ParamBinding
{

	class SimpeParamBindSample
	{

		[STAThread]
		static void Main(string[] args)
		{

			// Create BdpConnection
			String s_conn =
				"assembly=Borland.Data.Interbase,Version=2.5.0.0,Culture=" +
				"neutral,PublicKeyToken=91d62ebb5b0d1b1b;vendorclient=" +
				"gds32.dll;database=localhost:c:\\Borland\\Interbase\\" +
				"examples\\database\\employee.gdb;provider=Interbase;" +
				"username=sysdba;password=masterkey";
			BdpConnection bdp_conn = new BdpConnection( s_conn );

			String s_tablename = "EMPLOYEE_INFO";

			// Destroy Table if it already exists
			ExecuteCommand( bdp_conn, "Drop table " + s_tablename );

			// Create Table
			String s_create = "create table " + s_tablename +
				"(EMP_NO SMALLINT, FIRST_NAME VARCHAR(15), LAST_NAME " +
				"VARCHAR(20), PHONE_EXT VARCHAR(4), HIRE_DATE TIMESTAMP," +
				" DEPT_NO CHAR(3), JOB_CODE VARCHAR(5), JOB_GRADE SMALLINT," +
				" JOB_COUNTRY VARCHAR(15), SALARY DOUBLE PRECISION )";

			if (!ExecuteCommand( bdp_conn, s_create )){
				Console.Write("Error creating Table...\n Program terminating.");
				return;
			}

			// Create Insert Command with parameterized sql
			String s_insert = "INSERT INTO  " + s_tablename +
				"(EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, " +
				"DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY ) " +
				"VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
			BdpCommand bdp_insertComm = new BdpCommand( s_insert, bdp_conn );
			bdp_insertComm.Parameters.Add("EMP_NO", DbType.Int16);
			bdp_insertComm.Parameters.Add("FIRST_NAME", DbType.String);
			bdp_insertComm.Parameters.Add("LAST_NAME", DbType.String);
			bdp_insertComm.Parameters.Add("PHONE_EXT", DbType.String);
			bdp_insertComm.Parameters.Add("HIRE_DATE", DbType.DateTime);
			bdp_insertComm.Parameters.Add("DEPT_NO", DbType.String);
			bdp_insertComm.Parameters.Add("JOB_CODE", DbType.String);
			bdp_insertComm.Parameters.Add("JOB_GRADE", DbType.Int16);
			bdp_insertComm.Parameters.Add("JOB_COUNTRY", DbType.String);
			bdp_insertComm.Parameters.Add("SALARY", DbType.Double);  

			String s_datafile = "info.txt";
			FileStream fs_datafile = new FileStream(s_datafile, FileMode.Open, FileAccess.Read);
			StreamReader sr_filereader = new StreamReader( fs_datafile );

			BdpTransaction bdp_trans = null;
			try
			{

				bdp_conn.Open();

				bdp_insertComm.Prepare();
				bdp_trans = bdp_conn.BeginTransaction();

				String s_dataline;
				while ( (s_dataline = sr_filereader.ReadLine()) != null  )
				{
					String[] tokens = new String[bdp_insertComm.ParameterCount];
					tokens = s_dataline.Split(',');

					for ( int i = 0; i < bdp_insertComm.ParameterCount; i++ )
						bdp_insertComm.Parameters[i].Value = tokens[i];

					bdp_insertComm.ExecuteNonQuery();

				}

				bdp_trans.Commit();

			}
			catch(Exception e)
			{
				Console.Write("An Exception has occured: " + e.Message);
				if( bdp_trans != null)
					bdp_trans.Rollback();
			}

			// close file and reader streams
			sr_filereader.Close();
			fs_datafile.Close();

			// close command and connection
			bdp_insertComm.Close();
			bdp_conn.Close();

		}

		public static bool ExecuteCommand( BdpConnection conn, String comm_text ){

			try{
				if( conn.State != ConnectionState.Open )
					conn.Open();

				BdpTransaction bdp_trans = conn.BeginTransaction();
				BdpCommand command = new BdpCommand( comm_text, conn );
				command.ExecuteNonQuery();
				bdp_trans.Commit();

				conn.Close();
			}
			catch( Exception e )
			{
				return false;
			}

			return true;
		}
	}
}
